/**
 *
 */

#ifndef __meeting_api_delegate_h__
#define __meeting_api_delegate_h__

#include "jabber_meeting_sdk_def.h"
#include "csfunified/framework/UnifiedFactory.h"
#include "csf/logger/CSFLogger.hpp"
#include "csfunified/services/interface/RichPresenceStatus.h"
#include "csf/RWLock.hpp"

#include "services/impl/JabberServiceProvider.h"

namespace CSFUnified {

class MeetingApiDelegate : public JM_SDK::IJabberMeetingSDKDelegate,
    public SMART_PTR_NS::enable_shared_from_this<MeetingApiDelegate>
{
public:
	virtual ~MeetingApiDelegate();

public:
	static MeetingApiDelegate* getInstance();
	void initJabberAccountName();

public:
	// JM_SDK::IJabberMeetingSDKDelegate
	//IM Cmd
    virtual void sendInstantMeetingInvitation(const PString buddyName, const PString cmdMsg, const PString htmlMsg, const PString plantMsg);
	virtual void sendInstantMeetingCancelInvitation(const PString buddyName);
	virtual void sendInstantMeetingDecline(const PString buddyName);
	virtual void sendDesktopSharingInvitation(const PString buddyName, const PString cmdMsg, const PString htmlMsg, const PString plantMsg);
	virtual void sendDesktopSharingCancelInvitation(const PString buddyName);
	virtual void sendDesktopSharingDecline(const PString buddyName);
    


	//ds related
	virtual void hideChatWindow();
	virtual void showChatWindow();
	virtual void onUserTryLeave(bool isHost);
	

	//Presence
	virtual void addInMeetingPresence();
	virtual void removeInMeetingPresence();
	virtual void addInWebExMeetingPresence();
	virtual void removeInWebExMeetingPresence();
	virtual void addInWebExSharingPresence();
	virtual void removeInWebExSharingPresence();
	virtual void addInDesktopSharingPresence();
	virtual void removeInDesktopSharingPresence();
	virtual void addSharingInDesktopSharingPresence();
	virtual void removeShareingInDesktopSharingPresence();
    
public:
    std::string getMyDisplayName();
    
    virtual PString getJabberAccountName();
	virtual PString getJabberAccountNameFromEmail(const PString email);
    virtual void getAttendeeEmail(const PString attendeeJID, PString& attendeeEmail);
    virtual void getAttendeeDispalyName(const PString attendeeJID, PString& attendeeDN);
    
    virtual bool isAccount(const PString & sessionName);
    virtual bool IsDSPolicyEnable(const PString & sessionName, int & nPolicyResult);
    virtual bool hasDSCapability(const PString & sessionName);
    virtual bool hasIMCapability(const PString & sessionName);
    virtual bool isBuddyOnline(const PString & sessionName);
    virtual bool isCupModel();
    virtual bool isWbxMeetingEnabled();

	// IM command, meeting reminder related
    virtual void sendMeetingReminder(const PString buddyName, const PString cmdMsg, const PString htmlMsg, const PString plantMsg);

protected:
	MeetingApiDelegate();

private:
    std::string unescapeJid(const std::string & jid);
    void replaceAll(std::string& target, const std::string oldstr, const std::string newstr);

private:
	static MeetingApiDelegate* m_pInstance;
    SMART_PTR_NS::shared_ptr<UnifiedFactory> m_unifiedFactory;
    CSFLogger* m_pApiDelegateLogger;
    csf::RWLock mLock;

	std::string m_jabberAccountName;
    std::string m_jabberDisplayName;
    
    JabberServiceProvider* m_jabberServiceProvider;
};

}

#endif	// __meeting_api_delegate_h__